export const enum OBJECT_TYPE {
	CONTACT = 'contact',
	COMPANY = 'company',
	DEAL = 'deal',
	TICKET = 'ticket',
	PRODUCT = 'product',
	LINE_ITEM = 'line_item',
	TASK = 'task',
}

export const DEFAULT_CONTACT_PROPERTIES = [
	'firstname',
	'lastname',
	'email',
	'company',
	'website',
	'mobilephone',
	'phone',
	'fax',
	'address',
	'city',
	'state',
	'zip',
	'salutation',
	'country',
	'jobtitle',
	'hs_createdate',
	'hs_email_domain',
	'hs_object_id',
	'lastmodifieddate',
	'hs_persona',
	'hs_language',
	'lifecyclestage',
	'createdate',
	'numemployees',
	'annualrevenue',
	'industry',
];

export const DEFAULT_DEAL_PROPERTIES = [
	'dealtype',
	'dealname',
	'amount',
	'description',
	'closedate',
	'createdate',
	'num_associated_contacts',
	'hs_forecast_amount',
	'hs_forecast_probability',
	'hs_manual_forecast_category',
	'hs_next_step',
	'hs_object_id',
	'hs_lastmodifieddate',
	'hubspot_owner_id',
	'hubspot_team_id',
];

export const DEFAULT_TICKET_PROPERTIES = [
	'subject',
	'content',
	'source_type',
	'createdate',
	'hs_pipeline',
	'hs_pipeline_stage',
	'hs_resolution',
	'hs_ticket_category',
	'hs_ticket_id',
	'hs_ticket_priority',
	'hs_lastmodifieddate',
	'hubspot_owner_id',
	'hubspot_team_id',
];

export const DEFAULT_COMPANY_PROPERTIES = [
	'name',
	'domain',
	'industry',
	'about_us',
	'phone',
	'address',
	'address2',
	'city',
	'state',
	'zip',
	'country',
	'website',
	'type',
	'description',
	'founded_year',
	'hs_createdate',
	'hs_lastmodifieddate',
	'hs_object_id',
	'is_public',
	'timezone',
	'total_money_raised',
	'total_revenue',
	'owneremail',
	'ownername',
	'numberofemployees',
	'annualrevenue',
	'lifecyclestage',
	'createdate',
	'web_technologies',
];

export const DEFAULT_PRODUCT_PROPERTIES = [
	'createdate',
	'description',
	'name',
	'price',
	'tax',
	'hs_lastmodifieddate',
];

export const DEFAULT_LINE_ITEM_PROPERTIES = [
	'name',
	'description',
	'price',
	'quantity',
	'amount',
	'discount',
	'tax',
	'createdate',
	'hs_object_id',
	'hs_product_id',
	'hs_images',
	'hs_lastmodifieddate',
	'hs_line_item_currency_code',
	'hs_sku',
	'hs_url',
	'hs_cost_of_goods_sold',
	'hs_discount_percentage',
	'hs_term_in_months',
];



export const DEFAULT_TASK_PROPERTIES = [
	'hs_task_body',
	'hubspot_owner_id',
	'hs_task_subject',
	'hs_task_status',
	'hs_task_priority',
	'hs_task_type',
	'hs_created_by',
	'hs_repeat_status',
	'hs_task_completion_date',
	'hs_task_is_completed',
	'hs_timestamp',
	'hs_queue_membership_ids',
	'hs_lastmodifieddate',
	'hs_createdate',
];

export const STANDARD_OBJECT_TYPES = [
	{
		label: 'Contacts',
		value: OBJECT_TYPE.CONTACT,
	},
	{
		label: 'Companies',
		value: OBJECT_TYPE.COMPANY,
	},
	{
		label: 'Deals',
		value: OBJECT_TYPE.DEAL,
	},
	{
		label: 'Tickets',
		value: OBJECT_TYPE.TICKET,
	},
	{
		label: 'Line Items',
		value: OBJECT_TYPE.LINE_ITEM,
	},
];

