export const getTranscript = 
`
	query Transcript($transcriptId: String!) 
    {
		transcript(id: $transcriptId) 
        {
			id
			dateString
			privacy
			speakers 
            {
                id
                name
			}
			title
			host_email
			organizer_email
			calendar_id
			user 
            {
                user_id
                email
                name
                num_transcripts
                recent_meeting
                minutes_consumed
                is_admin
                integrations
			}
			fireflies_users
			participants
			date
			transcript_url
			audio_url
			video_url
			duration
			meeting_attendees 
            {
                displayName
                email
                phoneNumber
                name
                location
			}
			summary 
            {
                keywords
                action_items
                outline
                shorthand_bullet
                overview
                bullet_gist
                gist
                short_summary
                short_overview
                meeting_type
                topics_discussed
                transcript_chapters
			}
			cal_id
			calendar_type
			meeting_info 
            {
                fred_joined
                silent_meeting
                summary_status
			}
			meeting_link
		}
	}
`

export const getUser = 
`
query User($userId: String!) 
{
    user(id: $userId) 
    {
        user_id
        recent_transcript
        recent_meeting
        num_transcripts
        name
        minutes_consumed
        is_admin
        integrations
        email
        user_groups 
        {
            name
            handle
        }
    }
}`