
import { createPiece, PieceAuth } from '@activepieces/pieces-framework';
import {
  search,
  checkRedirect,
  getBlocks,
  getMainPageBlocks,
  getBlockByHash,
  getBlockTransactions,
  getBlockWithdrawals,
  getTransactions,
  getMainPageTransactions,
  getTransactionByHash,
  getTransactionTokenTransfers,
  getTransactionInternalTransactions,
  getTransactionLogs,
  getTransactionRawTrace,
  getTransactionStateChanges,
  getTransactionSummary,
  getAddresses,
  getAddressByHash,
  getAddressCounters,
  getAddressTransactions,
  getAddressTokenTransfers,
  getAddressLogs,
  getAddressBlocksValidated,
  getAddressTokenBalances,
  getAddressTokens,
  getAddressWithdrawals,
  getAddressCoinBalanceHistory,
  getAddressCoinBalanceHistoryByDay,
  getTokens,
  getTokenByAddress,
  getTokenTransfers,
  getTokenHolders,
  getTokenCounters,
  getTokenInstances
} from './lib/actions';

export const blockscout = createPiece({
  displayName: "Blockscout",
  description: "Blockscout is a tool for inspecting and analyzing EVM chains.",
  auth: PieceAuth.None(),
  logoUrl: 'https://cdn.activepieces.com/pieces/blockscout.png',
  authors: ['reemayoush'],
  actions: [
    search,
    checkRedirect,
    getBlocks,
    getMainPageBlocks,
    getBlockByHash,
    getBlockTransactions,
    getBlockWithdrawals,
    getTransactions,
    getMainPageTransactions,
    getTransactionByHash,
    getTransactionTokenTransfers,
    getTransactionInternalTransactions,
    getTransactionLogs,
    getTransactionRawTrace,
    getTransactionStateChanges,
    getTransactionSummary,
    getAddresses,
    getAddressByHash,
    getAddressCounters,
    getAddressTransactions,
    getAddressTokenTransfers,
    getAddressLogs,
    getAddressBlocksValidated,
    getAddressTokenBalances,
    getAddressTokens,
    getAddressWithdrawals,
    getAddressCoinBalanceHistory,
    getAddressCoinBalanceHistoryByDay,
    getTokens,
    getTokenByAddress,
    getTokenTransfers,
    getTokenHolders,
    getTokenCounters,
    getTokenInstances
  ],
  triggers: []
});

