The primary source of the Code of Conduct is here.

## 1. Purpose

A primary goal of the Activepieces community is to support you and your business in the development, use and implementation of Activepieces. It’s to be inclusive and add value to the largest number of participants, with the most varied and diverse backgrounds possible. As such, we are committed to providing a friendly, safe and welcoming environment for all.

This code of conduct outlines our expectations for all those who participate in our community, whether in-person or online, as well as the consequences for unacceptable behavior.

Your participation is contingent upon following these guidelines in all Activepieces activities, including but not limited to:

* Using Activepieces community resources.
* Working with other Activepiecesians and other Activepieces community participants whether virtually or co-located.
* Representing Activepieces at public events.
* Representing Activepieces in social media (official accounts, personal accounts, Facebook pages and groups).
* Participating in Activepieces sprints and training events.
* Participating in Activepieces-related forums, mailing lists, wikis, websites, chat channels, bugs, group or person-to-person meetings, and Activepieces-related correspondence.

We invite all those who participate in Activepieces activities online to help us create safe and positive experiences for everyone, everywhere.


## 2. Open Source & Culture Citizenship

A supplemental goal of this Code of Conduct is to increase open source and culture citizenship by encouraging participants to recognize and strengthen the relationships between our actions and their effects on our community.

Communities mirror the societies in which they exist and positive action is essential to counteract the many forms of inequality and abuses of power that exist in society.

If you see someone who is making an extra effort to ensure our community is welcoming, friendly, and encourages all participants to contribute to the fullest extent, please recognize their efforts.

## 3. Welcoming to all 
We are committed to providing a friendly, safe and welcoming environment for all, regardless of level of experience or job role, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, national origin, citizenship and immigration status, neurodiversity, mental health or socio-economic status. 


## 4. Expected Behavior

The following behaviors are expected and requested of all community members:

* Participate in an authentic and active way. In doing so, you contribute to the health and longevity of this community.
* Exercise consideration and respect in your speech and actions.
* Attempt collaboration before conflict.
* Guide conversations toward issue resolution.
* Refrain from demeaning, discriminatory, or harassing behavior and speech.

Alert Activepieces team members if you notice a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem inconsequential.

## 5. Unacceptable Behavior

The following behaviors are considered harassment and are unacceptable within our community:

* **Violence and Threats of Violence** are not acceptable - online or offline. This includes incitement of violence toward any individual, including encouraging a person to commit self-harm. This also includes posting or threatening to post other people’s personally identifying information (“doxxing”) online.
* **Public or private harassment** is never acceptable in any form.
* **Personal Attacks** Conflicts will inevitably arise, but frustration should never turn into a personal attack. It is not okay to insult, demean or belittle others. Attacking someone for their opinions, beliefs and ideas is not acceptable. It is important to speak directly when we disagree and when we think we need to improve, but such discussions must be conducted respectfully and professionally, remaining focused on the issue at hand.
* **Derogatory Language** Hurtful or harmful language is never acceptable in any context related to: background, family status, gender, gender identity or expression, marital status, sex, sexual orientation, personal appearance, body size, native language, age, ability, neurodiversity, mental health, race and/or ethnicity, national origin, citizenship and immigration status, socioeconomic status, religion, geographic location.
* **Unwelcome Sexual Attention or Physical Contact** Unwelcome sexual attention or unwelcome physical contact is not acceptable. This includes sexualized comments, jokes or imagery in interactions, communications or presentation materials, as well as inappropriate touching, groping, or sexual advances. This includes touching a person without permission, including sensitive areas such as their hair, pregnant stomach, mobility device (wheelchair, scooter, etc) or tattoos. This also includes physically blocking or intimidating another person. Physical contact or simulated physical contact (such as emojis like “kiss”) without affirmative consent is not acceptable. This includes sharing or distribution of sexualized images or text.
* **Disruptive Behavior** Sustained disruption of events, forums, or meetings, including talks and presentations, will not be tolerated. This includes spamming community discussions with the solicitation of unwanted products or services.
* **Influencing Disruptive Behavior** We will treat influencing or leading such activities the same way we treat the activities themselves, and thus the same consequences apply.
* **Corporate Promotions** Sharing of demo/trial/landing page links and other corporate promotions are never permitted unless explicitly requested by a community member. The only exceptions are that the moderated [Commercial forum category](https://forum.Activepieces.org/c/commercial) may be used to promote opportunities which may be relevant for members of the community (for example job opportunities, freelance gigs) and Activepieces Community Partners may promote their products and services on their partners page.
* **Scraping contacts** by name or any other personally identifiable information for unsolicited communication is never acceptable in any form. 

## 6. Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and those with decision-making authority, will not be tolerated.

Anyone asked to stop unacceptable behavior is expected to comply immediately.

If a community member engages in unacceptable behavior, we may take any action deemed appropriate, up to and including a temporary ban or permanent expulsion from the community without warning.  Examples of sanctions which may be applied include but is not limited to:
* Verbal warnings.
* Written warnings.
* Temporary absence from participation.
* Long-term absence from participation.
* Being required to follow a conduct agreement that dictates the process of returning to the community.


## 7. Reporting Guidelines
If you are subject to or witness unacceptable behavior, or have any other concerns, please notify us as soon as possible by emailing info@activepieces.com, or contacting a Activepieces team member on the specific platform.

Processes for dealing with breaches of the Code of Conduct can be found [here][coc-breaches].

## 8. Addressing Grievances
Only permanent resolutions (such as bans) may be appealed. To appeal a decision, contact the Activepieces team at info@activepieces.com with your appeal and the team will review the situation.

## 9. Scope
We expect all community participants (contributors, moderators and other guests) to abide by this Code of Conduct in all community venues–online and in-person–as well as in all one-on-one communications pertaining to community affairs.

While this code of conduct is specifically aimed at Activepieces’s official resources and community, we recognize that it is possible for actions taken outside of Activepieces’s official online or in person spaces to have a deep impact on community health. 

Resources or incidents which break this code of conduct for any reason in a non-Activepieces community location will be considered in the same way as resources or incidents from owned channels, and subject to the same sanctions. 

## 10. Contact info
For more information, please contact info@activepieces.com.

## 11. License and attribution
This Code of Conduct is directly adapted from the Stumptown Syndicate and distributed under a [Creative Commons Attribution-ShareAlike license][cc-by-sa].

Additional text from [Mozilla Community Participation Guidelines][mozilla-guidelines] distributed under a [Creative Commons Attribution-ShareAlike license][cc-by-sa].

Reviewed and updated using the [Mozilla Code of Conduct Assessment Tool][mozilla-tool].

[coc-breaches]: </policies/code-of-conduct-breaches>
[mozilla-guidelines]: <https://www.mozilla.org/en-US/about/governance/policies/participation/>
[cc-by-sa]: <https://creativecommons.org/licenses/by-sa/3.0/>
[mozilla-tool]:<https://mozilla.github.io/diversity-coc-review.io>

(Code of Conduct is subject to change without notice).
